package com.androidbook.commoncontrols;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.widget.RadioGroup;

public class RadioGroupActivity extends Activity {
	    protected static final String TAG = "RadioGroupActivity";

	    /** Wywoywane podczas pierwszego utworzenia aktywnoci. */
	    @Override
	    public void onCreate(Bundle savedInstanceState) {
	        super.onCreate(savedInstanceState);
	        setContentView(R.layout.radiogroup);
	        
	        RadioGroup radGrp = (RadioGroup)findViewById(R.id.radGrp);
	        
	        int checkedRadioButtonID = radGrp.getCheckedRadioButtonId();

	        radGrp.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
				public void onCheckedChanged(RadioGroup arg0, int id) {
					switch(id) {
					case -1:
						Log.v(TAG, "Zaznaczone elementy wyczyszczone!");
						break;
					case R.id.chRBtn:
						Log.v(TAG, "Wybrano Kurczak");
						break;
					case R.id.fishRBtn:
						Log.v(TAG, "Wybrano Ryba");
						break;
					case R.id.stkRBtn:
						Log.v(TAG, "Wybrano Stek");
						break;
					default:
						Log.v(TAG, "Hmm?");
						break;
					}
				}});
	    }
}
